#if 0
#elif defined(__arm64__) && __arm64__
// Generated by Apple Swift version 5.6.1 (swiftlang-5.6.0.323.66 clang-1316.0.20.12)
#ifndef DIDOMI_SWIFT_H
#define DIDOMI_SWIFT_H
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wgcc-compat"

#if !defined(__has_include)
# define __has_include(x) 0
#endif
#if !defined(__has_attribute)
# define __has_attribute(x) 0
#endif
#if !defined(__has_feature)
# define __has_feature(x) 0
#endif
#if !defined(__has_warning)
# define __has_warning(x) 0
#endif

#if __has_include(<swift/objc-prologue.h>)
# include <swift/objc-prologue.h>
#endif

#pragma clang diagnostic ignored "-Wauto-import"
#include <Foundation/Foundation.h>
#include <stdint.h>
#include <stddef.h>
#include <stdbool.h>

#if !defined(SWIFT_TYPEDEFS)
# define SWIFT_TYPEDEFS 1
# if __has_include(<uchar.h>)
#  include <uchar.h>
# elif !defined(__cplusplus)
typedef uint_least16_t char16_t;
typedef uint_least32_t char32_t;
# endif
typedef float swift_float2  __attribute__((__ext_vector_type__(2)));
typedef float swift_float3  __attribute__((__ext_vector_type__(3)));
typedef float swift_float4  __attribute__((__ext_vector_type__(4)));
typedef double swift_double2  __attribute__((__ext_vector_type__(2)));
typedef double swift_double3  __attribute__((__ext_vector_type__(3)));
typedef double swift_double4  __attribute__((__ext_vector_type__(4)));
typedef int swift_int2  __attribute__((__ext_vector_type__(2)));
typedef int swift_int3  __attribute__((__ext_vector_type__(3)));
typedef int swift_int4  __attribute__((__ext_vector_type__(4)));
typedef unsigned int swift_uint2  __attribute__((__ext_vector_type__(2)));
typedef unsigned int swift_uint3  __attribute__((__ext_vector_type__(3)));
typedef unsigned int swift_uint4  __attribute__((__ext_vector_type__(4)));
#endif

#if !defined(SWIFT_PASTE)
# define SWIFT_PASTE_HELPER(x, y) x##y
# define SWIFT_PASTE(x, y) SWIFT_PASTE_HELPER(x, y)
#endif
#if !defined(SWIFT_METATYPE)
# define SWIFT_METATYPE(X) Class
#endif
#if !defined(SWIFT_CLASS_PROPERTY)
# if __has_feature(objc_class_property)
#  define SWIFT_CLASS_PROPERTY(...) __VA_ARGS__
# else
#  define SWIFT_CLASS_PROPERTY(...)
# endif
#endif

#if __has_attribute(objc_runtime_name)
# define SWIFT_RUNTIME_NAME(X) __attribute__((objc_runtime_name(X)))
#else
# define SWIFT_RUNTIME_NAME(X)
#endif
#if __has_attribute(swift_name)
# define SWIFT_COMPILE_NAME(X) __attribute__((swift_name(X)))
#else
# define SWIFT_COMPILE_NAME(X)
#endif
#if __has_attribute(objc_method_family)
# define SWIFT_METHOD_FAMILY(X) __attribute__((objc_method_family(X)))
#else
# define SWIFT_METHOD_FAMILY(X)
#endif
#if __has_attribute(noescape)
# define SWIFT_NOESCAPE __attribute__((noescape))
#else
# define SWIFT_NOESCAPE
#endif
#if __has_attribute(ns_consumed)
# define SWIFT_RELEASES_ARGUMENT __attribute__((ns_consumed))
#else
# define SWIFT_RELEASES_ARGUMENT
#endif
#if __has_attribute(warn_unused_result)
# define SWIFT_WARN_UNUSED_RESULT __attribute__((warn_unused_result))
#else
# define SWIFT_WARN_UNUSED_RESULT
#endif
#if __has_attribute(noreturn)
# define SWIFT_NORETURN __attribute__((noreturn))
#else
# define SWIFT_NORETURN
#endif
#if !defined(SWIFT_CLASS_EXTRA)
# define SWIFT_CLASS_EXTRA
#endif
#if !defined(SWIFT_PROTOCOL_EXTRA)
# define SWIFT_PROTOCOL_EXTRA
#endif
#if !defined(SWIFT_ENUM_EXTRA)
# define SWIFT_ENUM_EXTRA
#endif
#if !defined(SWIFT_CLASS)
# if __has_attribute(objc_subclassing_restricted)
#  define SWIFT_CLASS(SWIFT_NAME) SWIFT_RUNTIME_NAME(SWIFT_NAME) __attribute__((objc_subclassing_restricted)) SWIFT_CLASS_EXTRA
#  define SWIFT_CLASS_NAMED(SWIFT_NAME) __attribute__((objc_subclassing_restricted)) SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_CLASS_EXTRA
# else
#  define SWIFT_CLASS(SWIFT_NAME) SWIFT_RUNTIME_NAME(SWIFT_NAME) SWIFT_CLASS_EXTRA
#  define SWIFT_CLASS_NAMED(SWIFT_NAME) SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_CLASS_EXTRA
# endif
#endif
#if !defined(SWIFT_RESILIENT_CLASS)
# if __has_attribute(objc_class_stub)
#  define SWIFT_RESILIENT_CLASS(SWIFT_NAME) SWIFT_CLASS(SWIFT_NAME) __attribute__((objc_class_stub))
#  define SWIFT_RESILIENT_CLASS_NAMED(SWIFT_NAME) __attribute__((objc_class_stub)) SWIFT_CLASS_NAMED(SWIFT_NAME)
# else
#  define SWIFT_RESILIENT_CLASS(SWIFT_NAME) SWIFT_CLASS(SWIFT_NAME)
#  define SWIFT_RESILIENT_CLASS_NAMED(SWIFT_NAME) SWIFT_CLASS_NAMED(SWIFT_NAME)
# endif
#endif

#if !defined(SWIFT_PROTOCOL)
# define SWIFT_PROTOCOL(SWIFT_NAME) SWIFT_RUNTIME_NAME(SWIFT_NAME) SWIFT_PROTOCOL_EXTRA
# define SWIFT_PROTOCOL_NAMED(SWIFT_NAME) SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_PROTOCOL_EXTRA
#endif

#if !defined(SWIFT_EXTENSION)
# define SWIFT_EXTENSION(M) SWIFT_PASTE(M##_Swift_, __LINE__)
#endif

#if !defined(OBJC_DESIGNATED_INITIALIZER)
# if __has_attribute(objc_designated_initializer)
#  define OBJC_DESIGNATED_INITIALIZER __attribute__((objc_designated_initializer))
# else
#  define OBJC_DESIGNATED_INITIALIZER
# endif
#endif
#if !defined(SWIFT_ENUM_ATTR)
# if defined(__has_attribute) && __has_attribute(enum_extensibility)
#  define SWIFT_ENUM_ATTR(_extensibility) __attribute__((enum_extensibility(_extensibility)))
# else
#  define SWIFT_ENUM_ATTR(_extensibility)
# endif
#endif
#if !defined(SWIFT_ENUM)
# define SWIFT_ENUM(_type, _name, _extensibility) enum _name : _type _name; enum SWIFT_ENUM_ATTR(_extensibility) SWIFT_ENUM_EXTRA _name : _type
# if __has_feature(generalized_swift_name)
#  define SWIFT_ENUM_NAMED(_type, _name, SWIFT_NAME, _extensibility) enum _name : _type _name SWIFT_COMPILE_NAME(SWIFT_NAME); enum SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_ENUM_ATTR(_extensibility) SWIFT_ENUM_EXTRA _name : _type
# else
#  define SWIFT_ENUM_NAMED(_type, _name, SWIFT_NAME, _extensibility) SWIFT_ENUM(_type, _name, _extensibility)
# endif
#endif
#if !defined(SWIFT_UNAVAILABLE)
# define SWIFT_UNAVAILABLE __attribute__((unavailable))
#endif
#if !defined(SWIFT_UNAVAILABLE_MSG)
# define SWIFT_UNAVAILABLE_MSG(msg) __attribute__((unavailable(msg)))
#endif
#if !defined(SWIFT_AVAILABILITY)
# define SWIFT_AVAILABILITY(plat, ...) __attribute__((availability(plat, __VA_ARGS__)))
#endif
#if !defined(SWIFT_WEAK_IMPORT)
# define SWIFT_WEAK_IMPORT __attribute__((weak_import))
#endif
#if !defined(SWIFT_DEPRECATED)
# define SWIFT_DEPRECATED __attribute__((deprecated))
#endif
#if !defined(SWIFT_DEPRECATED_MSG)
# define SWIFT_DEPRECATED_MSG(...) __attribute__((deprecated(__VA_ARGS__)))
#endif
#if __has_feature(attribute_diagnose_if_objc)
# define SWIFT_DEPRECATED_OBJC(Msg) __attribute__((diagnose_if(1, Msg, "warning")))
#else
# define SWIFT_DEPRECATED_OBJC(Msg) SWIFT_DEPRECATED_MSG(Msg)
#endif
#if !defined(IBSegueAction)
# define IBSegueAction
#endif
#if !defined(SWIFT_EXTERN)
# if defined(__cplusplus)
#  define SWIFT_EXTERN extern "C"
# else
#  define SWIFT_EXTERN extern
# endif
#endif
#if __has_feature(modules)
#if __has_warning("-Watimport-in-framework-header")
#pragma clang diagnostic ignored "-Watimport-in-framework-header"
#endif
@import Foundation;
@import ObjectiveC;
@import UIKit;
#endif

#pragma clang diagnostic ignored "-Wproperty-attribute-mismatch"
#pragma clang diagnostic ignored "-Wduplicate-method-arg"
#if __has_warning("-Wpragma-clang-attribute")
# pragma clang diagnostic ignored "-Wpragma-clang-attribute"
#endif
#pragma clang diagnostic ignored "-Wunknown-pragmas"
#pragma clang diagnostic ignored "-Wnullability"

#if __has_attribute(external_source_symbol)
# pragma push_macro("any")
# undef any
# pragma clang attribute push(__attribute__((external_source_symbol(language="Swift", defined_in="Didomi",generated_declaration))), apply_to=any(function,enum,objc_interface,objc_category,objc_protocol))
# pragma pop_macro("any")
#endif


/// Consent status to a vendor or purpose.
typedef SWIFT_ENUM(NSInteger, ConsentStatus, open) {
  ConsentStatusEnable = 0,
  ConsentStatusDisable = 1,
  ConsentStatusUnknown = 2,
};

@protocol ViewProviderDelegate;
@class NSString;
@class DidomiInitializeParameters;
@class DDMErrorEvent;
@class DDMEventListener;

SWIFT_CLASS("_TtC6Didomi6Didomi")
@interface Didomi : NSObject
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, strong) Didomi * _Nonnull shared;)
+ (Didomi * _Nonnull)shared SWIFT_WARN_UNUSED_RESULT;
+ (void)setShared:(Didomi * _Nonnull)value;
@property (nonatomic, weak) id <ViewProviderDelegate> _Nullable viewProviderDelegate;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
/// Initialize the Didomi SDK
/// \param apiKey Public API key of the organization from the Didomi Console.
///
/// \param localConfigurationPath Path to your local config file. Defaults to didomi_config.json if nil.
///
/// \param remoteConfigurationURL URL to a remote configuration file to load during initialization. This parameter is not used yet. Set it to nil for now.
///
/// \param providerId Your provider ID (if any).
///
/// \param disableDidomiRemoteConfig Whether to disable loading the remove configuration from the Didomi config. Keep this to “false” for loading configuration from the Didomi Console.
///
/// \param languageCode Language in which the consent UI should be displayed. By default, the consent UI is displayed in the language configured in the device settings. This property allows you to override the default setting and specify a language to display the UI in. String containing the language code e.g.: “es”, “fr”, etc.
///
- (void)initializeWithApiKey:(NSString * _Nonnull)apiKey localConfigurationPath:(NSString * _Nullable)localConfigurationPath remoteConfigurationURL:(NSString * _Nullable)remoteConfigurationURL providerId:(NSString * _Nullable)providerId disableDidomiRemoteConfig:(BOOL)disableDidomiRemoteConfig languageCode:(NSString * _Nullable)languageCode SWIFT_DEPRECATED_MSG("Use initialize(DidomiInitializeParameters) instead.");
/// Initialize the Didomi SDK
/// \param apiKey Public API key of the organization from the Didomi Console.
///
/// \param localConfigurationPath Path to your local config file. Defaults to didomi_config.json if nil.
///
/// \param remoteConfigurationURL URL to a remote configuration file to load during initialization. This parameter is not used yet. Set it to nil for now.
///
/// \param providerId Your provider ID (if any).
///
/// \param disableDidomiRemoteConfig Whether to disable loading the remove configuration from the Didomi config. Keep this to “false” for loading configuration from the Didomi Console.
///
/// \param languageCode Language in which the consent UI should be displayed. By default, the consent UI is displayed in the language configured in the device settings. This property allows you to override the default setting and specify a language to display the UI in. String containing the language code e.g.: “es”, “fr”, etc.
///
/// \param noticeId ID of the notice configuration to load from the Didomi Console.
///
- (void)initializeWithApiKey:(NSString * _Nonnull)apiKey localConfigurationPath:(NSString * _Nullable)localConfigurationPath remoteConfigurationURL:(NSString * _Nullable)remoteConfigurationURL providerId:(NSString * _Nullable)providerId disableDidomiRemoteConfig:(BOOL)disableDidomiRemoteConfig languageCode:(NSString * _Nullable)languageCode noticeId:(NSString * _Nullable)noticeId SWIFT_DEPRECATED_MSG("Use initialize(DidomiInitializeParameters) instead.");
/// Initialize the Didomi SDK
/// \param parameters object specifying parameters to initialize the SDK.
///
- (void)initialize:(DidomiInitializeParameters * _Nonnull)parameters;
/// Set custom user agent name and version.
/// \param name Agent name.
///
/// \param version Agent version.
///
- (void)setUserAgentWithName:(NSString * _Nonnull)name version:(NSString * _Nonnull)version;
/// Set the user consent status.
/// \param enabledPurposeIds set containing <em>enabled purpose ids</em>
///
/// \param disabledPurposeIds set containing <em>disabled purpose ids</em>
///
/// \param enabledVendorIds set containing <em>enabled vendor ids</em>
///
/// \param disabledVendorIds set containing <em>disabled purpose ids</em>
///
///
/// returns:
/// <em>true</em> if consent status has been updated, <em>false</em> otherwise.
- (BOOL)setUserConsentStatusWithEnabledPurposeIds:(NSSet<NSString *> * _Nonnull)enabledPurposeIds disabledPurposeIds:(NSSet<NSString *> * _Nonnull)disabledPurposeIds enabledVendorIds:(NSSet<NSString *> * _Nonnull)enabledVendorIds disabledVendorIds:(NSSet<NSString *> * _Nonnull)disabledVendorIds SWIFT_WARN_UNUSED_RESULT;
/// Determine if the user is subject to a regulation that requires consent collection.
/// This along with the choices that the user has or has not made
/// will determine each time that the SDK is initialized if the notice should be displayed or not.
///
/// returns:
/// <em>true</em> if consent is required, <em>false</em> if it is not required.
- (BOOL)isConsentRequired SWIFT_WARN_UNUSED_RESULT;
/// Determine if consent information is available for all purposes and vendors that are required
///
/// returns:
/// <em>true</em> if consent is required and consent information is available, <em>false</em> otherwise.
- (BOOL)isUserConsentStatusPartial SWIFT_WARN_UNUSED_RESULT;
/// Determine if legitimate interest information is available for all purposes and vendors that are required
///
/// returns:
/// <em>true</em> if consent is required and legitimate interest information is available, <em>false</em> otherwise.
- (BOOL)isUserLegitimateInterestStatusPartial SWIFT_WARN_UNUSED_RESULT;
/// Get the user consent status for a specific purpose
/// \param purposeId The purpose ID to check consent for
///
///
/// returns:
/// The user consent status for the specified purpose
- (enum ConsentStatus)getUserConsentStatusForPurposeWithPurposeId:(NSString * _Nonnull)purposeId SWIFT_WARN_UNUSED_RESULT SWIFT_DEPRECATED_MSG("Use getUserStatus() instead. Search for the purposeId in getUserStatus().purposes.global.enabled or getUserStatus().purposes.consent.disabled.");
/// Get the user legitimate interest status for a specific purpose.
/// \param purposeId purpose ID.
///
///
/// returns:
/// LI status of a purpose.
- (enum ConsentStatus)getUserLegitimateInterestStatusForPurposeWithPurposeId:(NSString * _Nonnull)purposeId SWIFT_WARN_UNUSED_RESULT SWIFT_DEPRECATED_MSG("Use getUserStatus() instead. Search for the purposeId in getUserStatus().purposes.global.enabled or getUserStatus().purposes.legitimateInterest.disabled.");
/// Get the user consent and legitimate interest status for a specific vendor.
/// \param vendorId vendor ID.
///
///
/// returns:
/// status that represents both consent and legitimate interest status of a vendor.
- (enum ConsentStatus)getUserStatusForVendorWithVendorId:(NSString * _Nonnull)vendorId SWIFT_WARN_UNUSED_RESULT SWIFT_DEPRECATED_MSG("Use getUserStatus() instead. Search for the vendorId in getUserStatus().vendors.global.enabled or getUserStatus().vendors.global.disabled.");
/// Get the user consent status for a specific vendor
/// \param vendorId The vendor ID to check consent for
///
///
/// returns:
/// The user consent status for the specified vendor
- (enum ConsentStatus)getUserConsentStatusForVendorWithVendorId:(NSString * _Nonnull)vendorId SWIFT_WARN_UNUSED_RESULT SWIFT_DEPRECATED_MSG("Use getUserStatus() instead. Search for the vendorId in getUserStatus().vendors.globalConsent.enabled or getUserStatus().vendors.consent.disabled.");
/// Get the user legitimate interest status for a specific vendor.
/// \param vendorId vendor ID.
///
///
/// returns:
/// LI status of a vendor.
- (enum ConsentStatus)getUserLegitimateInterestStatusForVendorWithVendorId:(NSString * _Nonnull)vendorId SWIFT_WARN_UNUSED_RESULT SWIFT_DEPRECATED_MSG("Use getUserStatus() instead. Search for the vendorId in getUserStatus().vendors.globalLegitimateInterest.enabled or getUserStatus().vendors.legitimateInterest.disabled.");
/// Get the user consent status for a specific vendor and all its purposes
/// \param vendorId The ID of the vendor
///
///
/// returns:
/// The user consent status corresponding to the specified vendor and all its required purposes.
- (enum ConsentStatus)getUserConsentStatusForVendorAndRequiredPurposesWithVendorId:(NSString * _Nonnull)vendorId SWIFT_WARN_UNUSED_RESULT SWIFT_DEPRECATED_MSG("Use getUserStatus() instead. Search for the vendorId in getUserStatus().vendors.globalConsent.enabled or getUserStatus().vendors.globalConsent.disabled.");
/// Get the user LI status for a specific vendor and all its purposes.
/// \param vendorId vendor ID.
///
///
/// returns:
/// The user LI status corresponding to the specified vendor and all its required purposes.
- (enum ConsentStatus)getUserLegitimateInterestStatusForVendorAndRequiredPurposesWithVendorId:(NSString * _Nonnull)vendorId SWIFT_WARN_UNUSED_RESULT SWIFT_DEPRECATED_MSG("Use getUserStatus() instead. Search for the vendorId in getUserStatus().vendors.globalLegitimateInterest.enabled or getUserStatus().vendors.globalLegitimateInterest.disabled.");
/// Set the user status for purposes and vendors for consent and legitimate interest.
/// \param purposesConsentStatus boolean used to determine if consent will be enabled or disabled for all purposes.
///
/// \param purposesLIStatus boolean used to determine if legitimate interest will be enabled or disabled for all purposes.
///
/// \param vendorsConsentStatus boolean used to determine if consent will be enabled or disabled for all vendors.
///
/// \param vendorsLIStatus boolean used to determine if legitimate interest will be enabled or disabled for all vendors.
///
///
/// returns:
/// <em>true</em> if consent status has been updated, <em>false</em> otherwise.
- (BOOL)setUserStatusWithPurposesConsentStatus:(BOOL)purposesConsentStatus purposesLIStatus:(BOOL)purposesLIStatus vendorsConsentStatus:(BOOL)vendorsConsentStatus vendorsLIStatus:(BOOL)vendorsLIStatus;
/// Set the user status for purposes and vendors for consent and legitimate interest.
/// \param enabledConsentPurposeIds List of purpose IDs to enable for consent.
///
/// \param disabledConsentPurposeIds List of purpose IDs to disable for consent.
///
/// \param enabledLIPurposeIds List of purpose IDs to enable for LI.
///
/// \param disabledLIPurposeIds List of purpose IDs to disable for LI.
///
/// \param enabledConsentVendorIds List of vendor IDs to enable for consent.
///
/// \param disabledConsentVendorIds List of vendor IDs to disable for consent.
///
/// \param enabledLIVendorIds List of vendor IDs to enable for LI.
///
/// \param disabledLIVendorIds List of vendor IDs to disable for LI.
///
- (BOOL)setUserStatusWithEnabledConsentPurposeIds:(NSSet<NSString *> * _Nonnull)enabledConsentPurposeIds disabledConsentPurposeIds:(NSSet<NSString *> * _Nonnull)disabledConsentPurposeIds enabledLIPurposeIds:(NSSet<NSString *> * _Nonnull)enabledLIPurposeIds disabledLIPurposeIds:(NSSet<NSString *> * _Nonnull)disabledLIPurposeIds enabledConsentVendorIds:(NSSet<NSString *> * _Nonnull)enabledConsentVendorIds disabledConsentVendorIds:(NSSet<NSString *> * _Nonnull)disabledConsentVendorIds enabledLIVendorIds:(NSSet<NSString *> * _Nonnull)enabledLIVendorIds disabledLIVendorIds:(NSSet<NSString *> * _Nonnull)disabledLIVendorIds;
/// Method that allows to enable consent and legitimate interest for all the required purposes.
///
/// returns:
/// <em>true</em> if consent status has been updated, <em>false</em> otherwise.
- (BOOL)setUserAgreeToAll;
/// Method that allows to disable consent and legitimate interest for all the required purposes and vendors.
///
/// returns:
/// <em>true</em> if consent status has been updated, <em>false</em> otherwise.
- (BOOL)setUserDisagreeToAll;
/// Provide a function that needs to be called once the SDK is ready
/// Automatically call the function if the SDK is already ready (that’s why this is not a standard event)
- (void)onReadyWithCallback:(void (^ _Nonnull)(void))callback;
/// Accepts a closure that will be called if an unexpected situation occurs.
/// \param callback closure to be called if an unexpected situation occurs.
///
- (void)onErrorWithCallback:(void (^ _Nonnull)(DDMErrorEvent * _Nonnull))callback;
/// Remove all consents for the user
- (void)reset;
/// Get the configured purpose IDs
/// @return
- (NSSet<NSString *> * _Nonnull)getRequiredPurposeIds SWIFT_WARN_UNUSED_RESULT;
/// Get the configured vendor IDs
/// @return
- (NSSet<NSString *> * _Nonnull)getRequiredVendorIds SWIFT_WARN_UNUSED_RESULT;
/// Add an event listener
/// \param listener listener to be added.
///
- (void)addEventListenerWithListener:(DDMEventListener * _Nonnull)listener;
/// Remove an event listener
/// \param listener listener to be removed.
///
- (void)removeEventListenerWithListener:(DDMEventListener * _Nonnull)listener;
/// Is the Didomi SDK ready?
- (BOOL)isReady SWIFT_WARN_UNUSED_RESULT;
/// Method used to get a set of enabled purpose IDs.
///
/// returns:
/// set that contains the IDs of enabled purposes.
- (NSSet<NSString *> * _Nonnull)getEnabledPurposeIds SWIFT_WARN_UNUSED_RESULT SWIFT_DEPRECATED_MSG("Use getUserStatus() instead. The result of this method has been replaced by getUserStatus().purposes.global.enabled.");
/// Method used to get a set of disabled purpose IDs.
///
/// returns:
/// set that contains the IDs of disabled purposes.
- (NSSet<NSString *> * _Nonnull)getDisabledPurposeIds SWIFT_WARN_UNUSED_RESULT SWIFT_DEPRECATED_MSG("Use getUserStatus() instead. The result of this method has been replaced by getUserStatus().purposes.consent.disabled.");
/// Method used to get a set of enabled vendor IDs.
///
/// returns:
/// set that contains the IDs of enabled vendors.
- (NSSet<NSString *> * _Nonnull)getEnabledVendorIds SWIFT_WARN_UNUSED_RESULT SWIFT_DEPRECATED_MSG("Use getUserStatus() instead. The result of this method has been replaced by getUserStatus().vendors.consent.enabled.");
/// Method used to get a set of disabled vendor IDs.
///
/// returns:
/// set that contains the IDs of disabled vendors.
- (NSSet<NSString *> * _Nonnull)getDisabledVendorIds SWIFT_WARN_UNUSED_RESULT SWIFT_DEPRECATED_MSG("Use getUserStatus() instead. The result of this method has been replaced by getUserStatus().vendors.consent.disabled.");
/// Get JavaScript to embed into a WebView to pass the consent status from the app
/// to the Didomi Web SDK embedded into the WebView
/// Inject the returned JavaScript into a WebView
/// \param extra Extra JavaScript to inject in the returned code
///
///
/// returns:
/// JavaScript code to inject in a WebView
- (NSString * _Nonnull)getJavaScriptForWebViewWithExtra:(NSString * _Nonnull)extra SWIFT_WARN_UNUSED_RESULT;
/// Get a query-string to add to the URL of a WebView or Chrome Custom Tab to pass the consent status from the app to the Didomi Web SDK embedded on the target URL.
/// The returned parameter will have the format <code>didomiConfig.user.externalConsent.value=...</code> It includes the user consent information URL-encoded and JSON-encoded.
/// Append the returned query-string parameter to the URL of your WebView or SFSafariViewController.
/// See https://developers.didomi.io/cmp/mobile-sdk/share-consent-with-webviews for more information.
///
/// returns:
/// Query string parameter to append to URL
- (NSString * _Nonnull)getQueryStringForWebView SWIFT_WARN_UNUSED_RESULT;
/// Method used to update the selected language of the Didomi SDK and any property that depends on it.
/// In most cases this method doesn’t need to be called. It would only be required for those apps that allow language change on-the-fly, i.e.: from within the app rather than from the device settings.
/// In order to update the language of the views displayed by the Didomi SDK, this method needs to be called before these views are displayed.
/// \param languageCode string containing the language code e.g.: “es”, “fr”, etc.
///
- (void)updateSelectedLanguageWithLanguageCode:(NSString * _Nonnull)languageCode;
@end

typedef SWIFT_ENUM(NSInteger, Views, open) {
  ViewsPurposes = 0,
  ViewsSensitivePersonalInformation = 1,
  ViewsVendors = 2,
};

@class UIViewController;

/// Protocol used to provide the view controllers for the preferences/purposes and notice view.
/// To provide customs views, this protocol will have to be implemented.
/// This protocol is implemented by the Didomi singleton to provide the default view controllers.
SWIFT_PROTOCOL("_TtP6Didomi20ViewProviderDelegate_")
@protocol ViewProviderDelegate
/// Method used to provide a view controller that will be used to display the notice.
/// \param position string that represents the position of the notice (e.g.: bottom, popup, etc.).
///
/// \param skipped Whether notice display is skipped and Preferences are displayed directly
///
///
/// returns:
/// the view controller associated to the notice.
- (UIViewController * _Nonnull)getNoticeViewControllerWithPosition:(NSString * _Nonnull)position noticeSkipped:(BOOL)noticeSkipped SWIFT_WARN_UNUSED_RESULT;
/// Method used to provide a view controller that will be used to display the preferences/purposes view.
///
/// returns:
/// the view controller associated to the preferences/purposes view.
- (UIViewController * _Nonnull)getPreferencesViewController SWIFT_WARN_UNUSED_RESULT;
@end


@interface Didomi (SWIFT_EXTENSION(Didomi)) <ViewProviderDelegate>
- (UIViewController * _Nonnull)getNoticeViewControllerWithPosition:(NSString * _Nonnull)position noticeSkipped:(BOOL)noticeSkipped SWIFT_WARN_UNUSED_RESULT;
- (UIViewController * _Nonnull)getPreferencesViewController SWIFT_WARN_UNUSED_RESULT;
@end

@class UserAuthParams;
@class DDMUserStatus;

@interface Didomi (SWIFT_EXTENSION(Didomi))
/// Provide the objects required to display UI elements
- (void)setupUIWithContainerController:(UIViewController * _Nonnull)containerController;
/// Force show the consent notice without checking if consent is required
/// Important: Do not keep a local reference to the View Controller itself as that could create a memory leak
- (void)forceShowNotice;
/// Show the consent notice (if required, not disabled in the config and not already displayed)
- (void)showNotice;
/// Hide the notice if it is currently displayed
- (void)hideNotice;
/// Check if the consent notice is currently displayed
/// @return
- (BOOL)isNoticeVisible SWIFT_WARN_UNUSED_RESULT;
/// Check if the consent should be collected depending on if we have any consents or if we have some consents but the number of days before displaying the notice again has not expired yet
///
/// returns:
/// A boolean depending if the consent should be collected or not
- (BOOL)shouldConsentBeCollected SWIFT_WARN_UNUSED_RESULT;
/// Show the preferences screen when/if the SDK is ready. By default the purposes list will be displayed.
/// \param controller view controller from where preferences will be presented.
///
/// \param view a value from <code>Didomi.Views</code>. It can be <code>.purposes</code> or <code>.sensitivePersonalInformation</code> or <code>.vendors</code> (<code>ViewsPurposes</code> or <code>ViewsSensitivePersonalInformation</code> or <code>ViewsVendors</code> in Objective-C)
///
- (void)showPreferencesWithController:(UIViewController * _Nullable)controller view:(enum Views)view;
/// Hide the preferences popup for purposes
- (void)hidePreferences;
/// Method used to check if the Preferences view is visible.
///
/// returns:
/// <em>true</em> if Preferences view is visible, <em>false</em> otherwise.
- (BOOL)isPreferencesVisible SWIFT_WARN_UNUSED_RESULT;
/// Method used to get a translated text based on the key being passed.
/// The language and the source of this translated text will depend on the availability of the translation for the specific key.
/// The language being used will be either the selected language of the SDK (based on device Locale and other parameters) or the language specified by app developers as the default language being used by the SDK. The source can be either the <code>didomi_config.json</code> file which can be either local or remote, or the <code>didomi_master_config.json</code> file which is bundled within the SDK.
/// These are the attempts performed by the SDK to try to find a translation for the specific key:
/// <ul>
///   <li>
///     Get translated value in user locale (selected language) from <code>didomi_config.json</code> (either local or remote).
///   </li>
///   <li>
///     Get translated value in default locale (from the config) from <code>didomi_config.json</code> (either local or remote).
///   </li>
///   <li>
///     Get translated value in user locale (selected language) from <code>didomi_master_config.json</code> (bundled within the Didomi SDK).
///   </li>
///   <li>
///     Get translated value in default locale (from the config) from <code>didomi_master_config.json</code> (bundled within the Didomi SDK).
///   </li>
/// </ul>
/// If no translation can be found after these 4 attempts, the key will be returned.
/// App developers can provide these translated texts through the <code>didomi_config.json</code> file (locally or remotely) in 3 different ways:
/// <ul>
///   <li>
///     Custom texts for the consent notice: https://developers.didomi.io/cmp/mobile-sdk/consent-notice/customize-the-notice#texts
///   </li>
///   <li>
///     Custom texts for the preferences: https://developers.didomi.io/cmp/mobile-sdk/consent-notice/customize-the-preferences-popup#text
///   </li>
///   <li>
///     Custom texts for custom notices: https://developers.didomi.io/cmp/mobile-sdk/consent-notice/customize-the-theme#translatable-texts-for-custom-notices
///   </li>
/// </ul>
/// \param key used to find its corresponding value in one of the different sources.
///
///
/// returns:
/// a translated string if a translation was found, the same key that was passed otherwise.
- (NSString * _Nonnull)getTranslatedTextWithKey:(NSString * _Nonnull)key SWIFT_WARN_UNUSED_RESULT;
/// Method used to get a dictionary/map in the form of { “en”: “Key in English”, “fr”: “Key in French.” }
/// for a given key.
/// \param key used to find its corresponding value in the dictionary/map.
///
///
/// returns:
/// dictionary containing the different translations for a given key.
- (NSDictionary<NSString *, NSString *> * _Nullable)getTextWithKey:(NSString * _Nonnull)key SWIFT_WARN_UNUSED_RESULT;
/// Set the minimum level of messages to log
/// Messages with a level below <code>minLevel</code> will not be logged.
/// Levels are standard levels from <code>OSLogType</code> (https://developer.apple.com/documentation/os/logging/choosing_the_log_level_for_a_message):
/// <ul>
///   <li>
///     OSLogType.info (1)
///   </li>
///   <li>
///     OSLogType.debug (2)
///   </li>
///   <li>
///     OSLogType.error (16)
///   </li>
///   <li>
///     OSLogType.fault (17)
///   </li>
/// </ul>
/// We recommend setting <code>OSLogType.error</code> (16) in production
/// \param minLevel Minimum level of messages to log
///
- (void)setLogLevelWithMinLevel:(uint8_t)minLevel;
/// Set organization user information
/// \param id Organization user ID
///
- (void)setUserWithId:(NSString * _Nonnull)id;
/// Set organization user information and display consent notice if it is needed after synchronization
/// \param id Organization user ID
///
/// \param containerController View controller from which we can setup Didomi UI
///
- (void)setUserWithId:(NSString * _Nonnull)id containerController:(UIViewController * _Nonnull)containerController;
/// Set organization user information with authentication
/// \param userAuthParams Organization user authentication params
///
- (void)setUserWithUserAuthParams:(UserAuthParams * _Nonnull)userAuthParams;
/// Set organization user information with authentication, and display consent notice if it is needed after synchronization
/// \param userAuthParams Organization user authentication params
///
/// \param containerController View controller from which we can setup Didomi UI
///
- (void)setUserWithUserAuthParams:(UserAuthParams * _Nonnull)userAuthParams containerController:(UIViewController * _Nonnull)containerController;
/// Set user information with authentication
/// \param id Organization user ID
///
/// \param algorithm Algorithm used for computing the digest
///
/// \param secretId ID of the secret used for computing the digest
///
/// \param salt Salt used for computing the digest (optional)
///
/// \param digest Digest of the organization user ID and secret
///
- (void)setUserWithId:(NSString * _Nonnull)id algorithm:(NSString * _Nonnull)algorithm secretId:(NSString * _Nonnull)secretId salt:(NSString * _Nullable)salt digest:(NSString * _Nonnull)digest SWIFT_DEPRECATED_MSG("Use setUser(UserAuthParams) instead.");
/// Remove organization user information (should be called when the SDK is initialized).
- (void)clearUser;
- (DDMUserStatus * _Nonnull)getUserStatus SWIFT_WARN_UNUSED_RESULT;
@end

enum DDMErrorEventType : NSInteger;

/// Type used to represent unexpected situations during SDK initialization.
SWIFT_CLASS_NAMED("DidomiErrorEvent")
@interface DDMErrorEvent : NSObject
@property (nonatomic, readonly, copy) NSString * _Nonnull descriptionText;
@property (nonatomic, readonly) enum DDMErrorEventType type;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// Enum used to represent a type for the DidomiErrorEvent class.
typedef SWIFT_ENUM_NAMED(NSInteger, DDMErrorEventType, "DidomiErrorEventType", open) {
  DDMErrorEventTypeNilProperty = 0,
  DDMErrorEventTypeNotReady = 1,
  DDMErrorEventTypeFailedAlready = 2,
  DDMErrorEventTypeConfigFileError = 3,
  DDMErrorEventTypeInvalidApiKey = 4,
};


/// Initialization parameters for Didomi SDK
SWIFT_CLASS("_TtC6Didomi26DidomiInitializeParameters")
@interface DidomiInitializeParameters : NSObject
- (nonnull instancetype)initWithApiKey:(NSString * _Nonnull)apiKey localConfigurationPath:(NSString * _Nullable)localConfigurationPath remoteConfigurationURL:(NSString * _Nullable)remoteConfigurationURL providerID:(NSString * _Nullable)providerID disableDidomiRemoteConfig:(BOOL)disableDidomiRemoteConfig languageCode:(NSString * _Nullable)languageCode noticeID:(NSString * _Nullable)noticeID OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


enum DDMEventType : NSInteger;

/// Class used as a listener for internal events occurred in the SDK.
SWIFT_CLASS_NAMED("EventListener")
@interface DDMEventListener : NSObject
/// Closures used to execute code when the different events are triggered.
/// Internal
@property (nonatomic, copy) void (^ _Nonnull onConsentChanged)(enum DDMEventType);
@property (nonatomic, copy) void (^ _Nonnull onReady)(enum DDMEventType);
@property (nonatomic, copy) void (^ _Nonnull onError)(DDMErrorEvent * _Nonnull);
/// Notice
@property (nonatomic, copy) void (^ _Nonnull onHideNotice)(enum DDMEventType);
@property (nonatomic, copy) void (^ _Nonnull onShowNotice)(enum DDMEventType);
@property (nonatomic, copy) void (^ _Nonnull onNoticeClickAgree)(enum DDMEventType);
@property (nonatomic, copy) void (^ _Nonnull onNoticeClickDisagree)(enum DDMEventType);
@property (nonatomic, copy) void (^ _Nonnull onNoticeClickMoreInfo)(enum DDMEventType);
@property (nonatomic, copy) void (^ _Nonnull onNoticeClickViewVendors)(enum DDMEventType);
@property (nonatomic, copy) void (^ _Nonnull onNoticeClickViewSPIPurposes)(enum DDMEventType);
@property (nonatomic, copy) void (^ _Nonnull onNoticeClickPrivacyPolicy)(enum DDMEventType);
/// Preferences
@property (nonatomic, copy) void (^ _Nonnull onHidePreferences)(enum DDMEventType);
@property (nonatomic, copy) void (^ _Nonnull onShowPreferences)(enum DDMEventType);
/// Preferences - Views
@property (nonatomic, copy) void (^ _Nonnull onPreferencesClickViewPurposes)(enum DDMEventType);
@property (nonatomic, copy) void (^ _Nonnull onPreferencesClickViewVendors)(enum DDMEventType);
@property (nonatomic, copy) void (^ _Nonnull onPreferencesClickViewSPIPurposes)(enum DDMEventType);
/// Preferences - Purpose
@property (nonatomic, copy) void (^ _Nonnull onPreferencesClickAgreeToAll)(enum DDMEventType);
@property (nonatomic, copy) void (^ _Nonnull onPreferencesClickDisagreeToAll)(enum DDMEventType);
@property (nonatomic, copy) void (^ _Nonnull onPreferencesClickAgreeToAllPurposes)(enum DDMEventType);
@property (nonatomic, copy) void (^ _Nonnull onPreferencesClickDisagreeToAllPurposes)(enum DDMEventType);
@property (nonatomic, copy) void (^ _Nonnull onPreferencesClickResetAllPurposes)(enum DDMEventType);
@property (nonatomic, copy) void (^ _Nonnull onPreferencesClickPurposeAgree)(enum DDMEventType, NSString * _Nullable);
@property (nonatomic, copy) void (^ _Nonnull onPreferencesClickPurposeDisagree)(enum DDMEventType, NSString * _Nullable);
@property (nonatomic, copy) void (^ _Nonnull onPreferencesClickCategoryAgree)(enum DDMEventType, NSString * _Nullable);
@property (nonatomic, copy) void (^ _Nonnull onPreferencesClickCategoryDisagree)(enum DDMEventType, NSString * _Nullable);
@property (nonatomic, copy) void (^ _Nonnull onPreferencesClickSaveChoices)(enum DDMEventType);
/// Preferences - Vendor
@property (nonatomic, copy) void (^ _Nonnull onPreferencesClickAgreeToAllVendors)(enum DDMEventType);
@property (nonatomic, copy) void (^ _Nonnull onPreferencesClickDisagreeToAllVendors)(enum DDMEventType);
@property (nonatomic, copy) void (^ _Nonnull onPreferencesClickVendorAgree)(enum DDMEventType, NSString * _Nullable);
@property (nonatomic, copy) void (^ _Nonnull onPreferencesClickVendorDisagree)(enum DDMEventType, NSString * _Nullable);
@property (nonatomic, copy) void (^ _Nonnull onPreferencesClickVendorSaveChoices)(enum DDMEventType);
/// Preferences - Sensitive Personal Information
@property (nonatomic, copy) void (^ _Nonnull onPreferencesClickSPIPurposeAgree)(enum DDMEventType, NSString * _Nullable);
@property (nonatomic, copy) void (^ _Nonnull onPreferencesClickSPIPurposeDisagree)(enum DDMEventType, NSString * _Nullable);
@property (nonatomic, copy) void (^ _Nonnull onPreferencesClickSPICategoryAgree)(enum DDMEventType, NSString * _Nullable);
@property (nonatomic, copy) void (^ _Nonnull onPreferencesClickSPICategoryDisagree)(enum DDMEventType, NSString * _Nullable);
@property (nonatomic, copy) void (^ _Nonnull onPreferencesClickSPIPurposeSaveChoices)(enum DDMEventType);
/// Sync
@property (nonatomic, copy) void (^ _Nonnull onSyncDone)(enum DDMEventType, NSString * _Nullable);
@property (nonatomic, copy) void (^ _Nonnull onSyncError)(enum DDMEventType, NSString * _Nullable);
/// Language
@property (nonatomic, copy) void (^ _Nonnull onLanguageUpdated)(enum DDMEventType, NSString * _Nullable);
@property (nonatomic, copy) void (^ _Nonnull onLanguageUpdateFailed)(enum DDMEventType, NSString * _Nullable);
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// Enum used to define the different type of internal events that can be triggered from the SDK.
/// Please keep the current order because of Unity bridge.
typedef SWIFT_ENUM_NAMED(NSInteger, DDMEventType, "EventType", open) {
  DDMEventTypeConsentChanged = 0,
  DDMEventTypeHideNotice = 1,
  DDMEventTypeReady = 2,
  DDMEventTypeShowNotice = 3,
  DDMEventTypeShowPreferences = 4,
  DDMEventTypeHidePreferences = 5,
  DDMEventTypeNoticeClickAgree = 6,
  DDMEventTypeNoticeClickDisagree = 7,
  DDMEventTypeNoticeClickMoreInfo = 8,
  DDMEventTypeNoticeClickViewVendors = 9,
  DDMEventTypeNoticeClickPrivacyPolicy = 10,
  DDMEventTypePreferencesClickAgreeToAll = 11,
  DDMEventTypePreferencesClickDisagreeToAll = 12,
  DDMEventTypePreferencesClickAgreeToAllPurposes = 13,
  DDMEventTypePreferencesClickDisagreeToAllPurposes = 14,
  DDMEventTypePreferencesClickResetAllPurposes = 15,
  DDMEventTypePreferencesClickAgreeToAllVendors = 16,
  DDMEventTypePreferencesClickDisagreeToAllVendors = 17,
  DDMEventTypePreferencesClickPurposeAgree = 18,
  DDMEventTypePreferencesClickPurposeDisagree = 19,
  DDMEventTypePreferencesClickCategoryAgree = 20,
  DDMEventTypePreferencesClickCategoryDisagree = 21,
  DDMEventTypePreferencesClickViewVendors = 22,
  DDMEventTypePreferencesClickViewPurposes = 23,
  DDMEventTypePreferencesClickSaveChoices = 24,
  DDMEventTypePreferencesClickVendorAgree = 25,
  DDMEventTypePreferencesClickVendorDisagree = 26,
  DDMEventTypePreferencesClickVendorSaveChoices = 27,
/// Sync
  DDMEventTypeSyncDone = 28,
  DDMEventTypeSyncError = 29,
/// Language
  DDMEventTypeLanguageUpdated = 30,
  DDMEventTypeLanguageUpdateFailed = 31,
/// Preferences - Sensitive Personal Information
  DDMEventTypeNoticeClickViewSPIPurposes = 32,
  DDMEventTypePreferencesClickViewSPIPurposes = 33,
  DDMEventTypePreferencesClickSPIPurposeAgree = 34,
  DDMEventTypePreferencesClickSPIPurposeDisagree = 35,
  DDMEventTypePreferencesClickSPICategoryAgree = 36,
  DDMEventTypePreferencesClickSPICategoryDisagree = 37,
  DDMEventTypePreferencesClickSPIPurposeSaveChoices = 38,
};






@class NSCoder;
@protocol UIFocusEnvironment;
@class NSBundle;

SWIFT_CLASS("_TtC6Didomi20NoticeViewController")
@interface NoticeViewController : UIViewController
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)aDecoder OBJC_DESIGNATED_INITIALIZER;
- (void)viewDidLoad;
@property (nonatomic, readonly, copy) NSArray<id <UIFocusEnvironment>> * _Nonnull preferredFocusEnvironments;
- (nonnull instancetype)initWithNibName:(NSString * _Nullable)nibNameOrNil bundle:(NSBundle * _Nullable)nibBundleOrNil SWIFT_UNAVAILABLE;
@end




/// Regulation for which Didomi SDK is currently configured. Only one regulation is active at each run.
typedef SWIFT_ENUM(NSInteger, Regulation, open) {
  RegulationGdpr = 0,
  RegulationCcpa = 1,
  RegulationCpa = 2,
  RegulationCpra = 3,
  RegulationCtdpa = 4,
  RegulationUcpa = 5,
  RegulationVcdpa = 6,
  RegulationNone = 7,
};


















/// Protocol for User Authentication
/// declare the user id
SWIFT_PROTOCOL("_TtP6Didomi8UserAuth_")
@protocol UserAuth
/// Organization ID to associate with the user
@property (nonatomic, readonly, copy) NSString * _Nonnull id;
@end


/// Protocol for User Authentication Parameters
/// declare the common properties of encryption / hash parameters
SWIFT_CLASS("_TtC6Didomi14UserAuthParams")
@interface UserAuthParams : NSObject <UserAuth>
/// Organization ID to associate with the user
@property (nonatomic, copy) NSString * _Nonnull id;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


/// User Authentication Parameters with encryption
SWIFT_CLASS("_TtC6Didomi28UserAuthWithEncryptionParams")
@interface UserAuthWithEncryptionParams : UserAuthParams
- (nonnull instancetype)initWithId:(NSString * _Nonnull)id algorithm:(NSString * _Nonnull)algorithm secretID:(NSString * _Nonnull)secretID initializationVector:(NSString * _Nonnull)initializationVector;
/// Initializer for Objective-C
- (nonnull instancetype)initWithId:(NSString * _Nonnull)id algorithm:(NSString * _Nonnull)algorithm secretID:(NSString * _Nonnull)secretID initializationVector:(NSString * _Nonnull)initializationVector legacyExpiration:(NSTimeInterval)legacyExpiration;
/// Initialization Vector used for computing the user ID
@property (nonatomic, copy) NSString * _Nonnull initializationVector;
@end


/// User Authentication Parameters with hash
SWIFT_CLASS("_TtC6Didomi22UserAuthWithHashParams")
@interface UserAuthWithHashParams : UserAuthParams
- (nonnull instancetype)initWithId:(NSString * _Nonnull)id algorithm:(NSString * _Nonnull)algorithm secretID:(NSString * _Nonnull)secretID digest:(NSString * _Nonnull)digest salt:(NSString * _Nullable)salt;
/// Initializer for Objective-C
- (nonnull instancetype)initWithId:(NSString * _Nonnull)id algorithm:(NSString * _Nonnull)algorithm secretID:(NSString * _Nonnull)secretID digest:(NSString * _Nonnull)digest salt:(NSString * _Nullable)salt legacyExpiration:(NSTimeInterval)legacyExpiration;
/// Salt used for computing the user ID (optional)
@property (nonatomic, copy) NSString * _Nullable salt;
/// Digest used for representing the user ID
@property (nonatomic, copy) NSString * _Nonnull digest;
@end

@class DDMUserStatusPurposes;
@class DDMUserStatusVendors;

SWIFT_CLASS_NAMED("UserStatus")
@interface DDMUserStatus : NSObject
@property (nonatomic, readonly, strong) DDMUserStatusPurposes * _Nonnull purposes;
@property (nonatomic, readonly, strong) DDMUserStatusVendors * _Nonnull vendors;
@property (nonatomic, readonly, copy) NSString * _Nonnull userID;
@property (nonatomic, readonly, copy) NSString * _Nonnull created;
@property (nonatomic, readonly, copy) NSString * _Nonnull updated;
@property (nonatomic, readonly, copy) NSString * _Nonnull consentString;
@property (nonatomic, readonly, copy) NSString * _Nonnull additionalConsent;
@property (nonatomic, readonly) enum Regulation regulation;
- (BOOL)isEqual:(id _Nullable)object SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


@interface DDMUserStatus (SWIFT_EXTENSION(Didomi))
@end

@class DDMUserStatusIDs;

SWIFT_CLASS_NAMED("Purposes")
@interface DDMUserStatusPurposes : NSObject
@property (nonatomic, readonly, strong) DDMUserStatusIDs * _Nonnull consent;
@property (nonatomic, readonly, strong) DDMUserStatusIDs * _Nonnull legitimateInterest;
@property (nonatomic, readonly, strong) DDMUserStatusIDs * _Nonnull global;
@property (nonatomic, readonly, copy) NSSet<NSString *> * _Nonnull essential;
- (BOOL)isEqual:(id _Nullable)object SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


@interface DDMUserStatus (SWIFT_EXTENSION(Didomi))
@end


SWIFT_CLASS_NAMED("Vendors")
@interface DDMUserStatusVendors : NSObject
@property (nonatomic, readonly, strong) DDMUserStatusIDs * _Nonnull consent;
@property (nonatomic, readonly, strong) DDMUserStatusIDs * _Nonnull legitimateInterest;
@property (nonatomic, readonly, strong) DDMUserStatusIDs * _Nonnull global;
@property (nonatomic, readonly, strong) DDMUserStatusIDs * _Nonnull globalConsent;
@property (nonatomic, readonly, strong) DDMUserStatusIDs * _Nonnull globalLegitimateInterest;
- (BOOL)isEqual:(id _Nullable)object SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


@interface DDMUserStatus (SWIFT_EXTENSION(Didomi))
@end


SWIFT_CLASS_NAMED("IDs")
@interface DDMUserStatusIDs : NSObject
@property (nonatomic, readonly, copy) NSSet<NSString *> * _Nonnull enabled;
@property (nonatomic, readonly, copy) NSSet<NSString *> * _Nonnull disabled;
- (BOOL)isEqual:(id _Nullable)object SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end



#if __has_attribute(external_source_symbol)
# pragma clang attribute pop
#endif
#pragma clang diagnostic pop
#endif

#elif defined(__x86_64__) && __x86_64__
// Generated by Apple Swift version 5.6.1 (swiftlang-5.6.0.323.66 clang-1316.0.20.12)
#ifndef DIDOMI_SWIFT_H
#define DIDOMI_SWIFT_H
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wgcc-compat"

#if !defined(__has_include)
# define __has_include(x) 0
#endif
#if !defined(__has_attribute)
# define __has_attribute(x) 0
#endif
#if !defined(__has_feature)
# define __has_feature(x) 0
#endif
#if !defined(__has_warning)
# define __has_warning(x) 0
#endif

#if __has_include(<swift/objc-prologue.h>)
# include <swift/objc-prologue.h>
#endif

#pragma clang diagnostic ignored "-Wauto-import"
#include <Foundation/Foundation.h>
#include <stdint.h>
#include <stddef.h>
#include <stdbool.h>

#if !defined(SWIFT_TYPEDEFS)
# define SWIFT_TYPEDEFS 1
# if __has_include(<uchar.h>)
#  include <uchar.h>
# elif !defined(__cplusplus)
typedef uint_least16_t char16_t;
typedef uint_least32_t char32_t;
# endif
typedef float swift_float2  __attribute__((__ext_vector_type__(2)));
typedef float swift_float3  __attribute__((__ext_vector_type__(3)));
typedef float swift_float4  __attribute__((__ext_vector_type__(4)));
typedef double swift_double2  __attribute__((__ext_vector_type__(2)));
typedef double swift_double3  __attribute__((__ext_vector_type__(3)));
typedef double swift_double4  __attribute__((__ext_vector_type__(4)));
typedef int swift_int2  __attribute__((__ext_vector_type__(2)));
typedef int swift_int3  __attribute__((__ext_vector_type__(3)));
typedef int swift_int4  __attribute__((__ext_vector_type__(4)));
typedef unsigned int swift_uint2  __attribute__((__ext_vector_type__(2)));
typedef unsigned int swift_uint3  __attribute__((__ext_vector_type__(3)));
typedef unsigned int swift_uint4  __attribute__((__ext_vector_type__(4)));
#endif

#if !defined(SWIFT_PASTE)
# define SWIFT_PASTE_HELPER(x, y) x##y
# define SWIFT_PASTE(x, y) SWIFT_PASTE_HELPER(x, y)
#endif
#if !defined(SWIFT_METATYPE)
# define SWIFT_METATYPE(X) Class
#endif
#if !defined(SWIFT_CLASS_PROPERTY)
# if __has_feature(objc_class_property)
#  define SWIFT_CLASS_PROPERTY(...) __VA_ARGS__
# else
#  define SWIFT_CLASS_PROPERTY(...)
# endif
#endif

#if __has_attribute(objc_runtime_name)
# define SWIFT_RUNTIME_NAME(X) __attribute__((objc_runtime_name(X)))
#else
# define SWIFT_RUNTIME_NAME(X)
#endif
#if __has_attribute(swift_name)
# define SWIFT_COMPILE_NAME(X) __attribute__((swift_name(X)))
#else
# define SWIFT_COMPILE_NAME(X)
#endif
#if __has_attribute(objc_method_family)
# define SWIFT_METHOD_FAMILY(X) __attribute__((objc_method_family(X)))
#else
# define SWIFT_METHOD_FAMILY(X)
#endif
#if __has_attribute(noescape)
# define SWIFT_NOESCAPE __attribute__((noescape))
#else
# define SWIFT_NOESCAPE
#endif
#if __has_attribute(ns_consumed)
# define SWIFT_RELEASES_ARGUMENT __attribute__((ns_consumed))
#else
# define SWIFT_RELEASES_ARGUMENT
#endif
#if __has_attribute(warn_unused_result)
# define SWIFT_WARN_UNUSED_RESULT __attribute__((warn_unused_result))
#else
# define SWIFT_WARN_UNUSED_RESULT
#endif
#if __has_attribute(noreturn)
# define SWIFT_NORETURN __attribute__((noreturn))
#else
# define SWIFT_NORETURN
#endif
#if !defined(SWIFT_CLASS_EXTRA)
# define SWIFT_CLASS_EXTRA
#endif
#if !defined(SWIFT_PROTOCOL_EXTRA)
# define SWIFT_PROTOCOL_EXTRA
#endif
#if !defined(SWIFT_ENUM_EXTRA)
# define SWIFT_ENUM_EXTRA
#endif
#if !defined(SWIFT_CLASS)
# if __has_attribute(objc_subclassing_restricted)
#  define SWIFT_CLASS(SWIFT_NAME) SWIFT_RUNTIME_NAME(SWIFT_NAME) __attribute__((objc_subclassing_restricted)) SWIFT_CLASS_EXTRA
#  define SWIFT_CLASS_NAMED(SWIFT_NAME) __attribute__((objc_subclassing_restricted)) SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_CLASS_EXTRA
# else
#  define SWIFT_CLASS(SWIFT_NAME) SWIFT_RUNTIME_NAME(SWIFT_NAME) SWIFT_CLASS_EXTRA
#  define SWIFT_CLASS_NAMED(SWIFT_NAME) SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_CLASS_EXTRA
# endif
#endif
#if !defined(SWIFT_RESILIENT_CLASS)
# if __has_attribute(objc_class_stub)
#  define SWIFT_RESILIENT_CLASS(SWIFT_NAME) SWIFT_CLASS(SWIFT_NAME) __attribute__((objc_class_stub))
#  define SWIFT_RESILIENT_CLASS_NAMED(SWIFT_NAME) __attribute__((objc_class_stub)) SWIFT_CLASS_NAMED(SWIFT_NAME)
# else
#  define SWIFT_RESILIENT_CLASS(SWIFT_NAME) SWIFT_CLASS(SWIFT_NAME)
#  define SWIFT_RESILIENT_CLASS_NAMED(SWIFT_NAME) SWIFT_CLASS_NAMED(SWIFT_NAME)
# endif
#endif

#if !defined(SWIFT_PROTOCOL)
# define SWIFT_PROTOCOL(SWIFT_NAME) SWIFT_RUNTIME_NAME(SWIFT_NAME) SWIFT_PROTOCOL_EXTRA
# define SWIFT_PROTOCOL_NAMED(SWIFT_NAME) SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_PROTOCOL_EXTRA
#endif

#if !defined(SWIFT_EXTENSION)
# define SWIFT_EXTENSION(M) SWIFT_PASTE(M##_Swift_, __LINE__)
#endif

#if !defined(OBJC_DESIGNATED_INITIALIZER)
# if __has_attribute(objc_designated_initializer)
#  define OBJC_DESIGNATED_INITIALIZER __attribute__((objc_designated_initializer))
# else
#  define OBJC_DESIGNATED_INITIALIZER
# endif
#endif
#if !defined(SWIFT_ENUM_ATTR)
# if defined(__has_attribute) && __has_attribute(enum_extensibility)
#  define SWIFT_ENUM_ATTR(_extensibility) __attribute__((enum_extensibility(_extensibility)))
# else
#  define SWIFT_ENUM_ATTR(_extensibility)
# endif
#endif
#if !defined(SWIFT_ENUM)
# define SWIFT_ENUM(_type, _name, _extensibility) enum _name : _type _name; enum SWIFT_ENUM_ATTR(_extensibility) SWIFT_ENUM_EXTRA _name : _type
# if __has_feature(generalized_swift_name)
#  define SWIFT_ENUM_NAMED(_type, _name, SWIFT_NAME, _extensibility) enum _name : _type _name SWIFT_COMPILE_NAME(SWIFT_NAME); enum SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_ENUM_ATTR(_extensibility) SWIFT_ENUM_EXTRA _name : _type
# else
#  define SWIFT_ENUM_NAMED(_type, _name, SWIFT_NAME, _extensibility) SWIFT_ENUM(_type, _name, _extensibility)
# endif
#endif
#if !defined(SWIFT_UNAVAILABLE)
# define SWIFT_UNAVAILABLE __attribute__((unavailable))
#endif
#if !defined(SWIFT_UNAVAILABLE_MSG)
# define SWIFT_UNAVAILABLE_MSG(msg) __attribute__((unavailable(msg)))
#endif
#if !defined(SWIFT_AVAILABILITY)
# define SWIFT_AVAILABILITY(plat, ...) __attribute__((availability(plat, __VA_ARGS__)))
#endif
#if !defined(SWIFT_WEAK_IMPORT)
# define SWIFT_WEAK_IMPORT __attribute__((weak_import))
#endif
#if !defined(SWIFT_DEPRECATED)
# define SWIFT_DEPRECATED __attribute__((deprecated))
#endif
#if !defined(SWIFT_DEPRECATED_MSG)
# define SWIFT_DEPRECATED_MSG(...) __attribute__((deprecated(__VA_ARGS__)))
#endif
#if __has_feature(attribute_diagnose_if_objc)
# define SWIFT_DEPRECATED_OBJC(Msg) __attribute__((diagnose_if(1, Msg, "warning")))
#else
# define SWIFT_DEPRECATED_OBJC(Msg) SWIFT_DEPRECATED_MSG(Msg)
#endif
#if !defined(IBSegueAction)
# define IBSegueAction
#endif
#if !defined(SWIFT_EXTERN)
# if defined(__cplusplus)
#  define SWIFT_EXTERN extern "C"
# else
#  define SWIFT_EXTERN extern
# endif
#endif
#if __has_feature(modules)
#if __has_warning("-Watimport-in-framework-header")
#pragma clang diagnostic ignored "-Watimport-in-framework-header"
#endif
@import Foundation;
@import ObjectiveC;
@import UIKit;
#endif

#pragma clang diagnostic ignored "-Wproperty-attribute-mismatch"
#pragma clang diagnostic ignored "-Wduplicate-method-arg"
#if __has_warning("-Wpragma-clang-attribute")
# pragma clang diagnostic ignored "-Wpragma-clang-attribute"
#endif
#pragma clang diagnostic ignored "-Wunknown-pragmas"
#pragma clang diagnostic ignored "-Wnullability"

#if __has_attribute(external_source_symbol)
# pragma push_macro("any")
# undef any
# pragma clang attribute push(__attribute__((external_source_symbol(language="Swift", defined_in="Didomi",generated_declaration))), apply_to=any(function,enum,objc_interface,objc_category,objc_protocol))
# pragma pop_macro("any")
#endif


/// Consent status to a vendor or purpose.
typedef SWIFT_ENUM(NSInteger, ConsentStatus, open) {
  ConsentStatusEnable = 0,
  ConsentStatusDisable = 1,
  ConsentStatusUnknown = 2,
};

@protocol ViewProviderDelegate;
@class NSString;
@class DidomiInitializeParameters;
@class DDMErrorEvent;
@class DDMEventListener;

SWIFT_CLASS("_TtC6Didomi6Didomi")
@interface Didomi : NSObject
SWIFT_CLASS_PROPERTY(@property (nonatomic, class, strong) Didomi * _Nonnull shared;)
+ (Didomi * _Nonnull)shared SWIFT_WARN_UNUSED_RESULT;
+ (void)setShared:(Didomi * _Nonnull)value;
@property (nonatomic, weak) id <ViewProviderDelegate> _Nullable viewProviderDelegate;
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
/// Initialize the Didomi SDK
/// \param apiKey Public API key of the organization from the Didomi Console.
///
/// \param localConfigurationPath Path to your local config file. Defaults to didomi_config.json if nil.
///
/// \param remoteConfigurationURL URL to a remote configuration file to load during initialization. This parameter is not used yet. Set it to nil for now.
///
/// \param providerId Your provider ID (if any).
///
/// \param disableDidomiRemoteConfig Whether to disable loading the remove configuration from the Didomi config. Keep this to “false” for loading configuration from the Didomi Console.
///
/// \param languageCode Language in which the consent UI should be displayed. By default, the consent UI is displayed in the language configured in the device settings. This property allows you to override the default setting and specify a language to display the UI in. String containing the language code e.g.: “es”, “fr”, etc.
///
- (void)initializeWithApiKey:(NSString * _Nonnull)apiKey localConfigurationPath:(NSString * _Nullable)localConfigurationPath remoteConfigurationURL:(NSString * _Nullable)remoteConfigurationURL providerId:(NSString * _Nullable)providerId disableDidomiRemoteConfig:(BOOL)disableDidomiRemoteConfig languageCode:(NSString * _Nullable)languageCode SWIFT_DEPRECATED_MSG("Use initialize(DidomiInitializeParameters) instead.");
/// Initialize the Didomi SDK
/// \param apiKey Public API key of the organization from the Didomi Console.
///
/// \param localConfigurationPath Path to your local config file. Defaults to didomi_config.json if nil.
///
/// \param remoteConfigurationURL URL to a remote configuration file to load during initialization. This parameter is not used yet. Set it to nil for now.
///
/// \param providerId Your provider ID (if any).
///
/// \param disableDidomiRemoteConfig Whether to disable loading the remove configuration from the Didomi config. Keep this to “false” for loading configuration from the Didomi Console.
///
/// \param languageCode Language in which the consent UI should be displayed. By default, the consent UI is displayed in the language configured in the device settings. This property allows you to override the default setting and specify a language to display the UI in. String containing the language code e.g.: “es”, “fr”, etc.
///
/// \param noticeId ID of the notice configuration to load from the Didomi Console.
///
- (void)initializeWithApiKey:(NSString * _Nonnull)apiKey localConfigurationPath:(NSString * _Nullable)localConfigurationPath remoteConfigurationURL:(NSString * _Nullable)remoteConfigurationURL providerId:(NSString * _Nullable)providerId disableDidomiRemoteConfig:(BOOL)disableDidomiRemoteConfig languageCode:(NSString * _Nullable)languageCode noticeId:(NSString * _Nullable)noticeId SWIFT_DEPRECATED_MSG("Use initialize(DidomiInitializeParameters) instead.");
/// Initialize the Didomi SDK
/// \param parameters object specifying parameters to initialize the SDK.
///
- (void)initialize:(DidomiInitializeParameters * _Nonnull)parameters;
/// Set custom user agent name and version.
/// \param name Agent name.
///
/// \param version Agent version.
///
- (void)setUserAgentWithName:(NSString * _Nonnull)name version:(NSString * _Nonnull)version;
/// Set the user consent status.
/// \param enabledPurposeIds set containing <em>enabled purpose ids</em>
///
/// \param disabledPurposeIds set containing <em>disabled purpose ids</em>
///
/// \param enabledVendorIds set containing <em>enabled vendor ids</em>
///
/// \param disabledVendorIds set containing <em>disabled purpose ids</em>
///
///
/// returns:
/// <em>true</em> if consent status has been updated, <em>false</em> otherwise.
- (BOOL)setUserConsentStatusWithEnabledPurposeIds:(NSSet<NSString *> * _Nonnull)enabledPurposeIds disabledPurposeIds:(NSSet<NSString *> * _Nonnull)disabledPurposeIds enabledVendorIds:(NSSet<NSString *> * _Nonnull)enabledVendorIds disabledVendorIds:(NSSet<NSString *> * _Nonnull)disabledVendorIds SWIFT_WARN_UNUSED_RESULT;
/// Determine if the user is subject to a regulation that requires consent collection.
/// This along with the choices that the user has or has not made
/// will determine each time that the SDK is initialized if the notice should be displayed or not.
///
/// returns:
/// <em>true</em> if consent is required, <em>false</em> if it is not required.
- (BOOL)isConsentRequired SWIFT_WARN_UNUSED_RESULT;
/// Determine if consent information is available for all purposes and vendors that are required
///
/// returns:
/// <em>true</em> if consent is required and consent information is available, <em>false</em> otherwise.
- (BOOL)isUserConsentStatusPartial SWIFT_WARN_UNUSED_RESULT;
/// Determine if legitimate interest information is available for all purposes and vendors that are required
///
/// returns:
/// <em>true</em> if consent is required and legitimate interest information is available, <em>false</em> otherwise.
- (BOOL)isUserLegitimateInterestStatusPartial SWIFT_WARN_UNUSED_RESULT;
/// Get the user consent status for a specific purpose
/// \param purposeId The purpose ID to check consent for
///
///
/// returns:
/// The user consent status for the specified purpose
- (enum ConsentStatus)getUserConsentStatusForPurposeWithPurposeId:(NSString * _Nonnull)purposeId SWIFT_WARN_UNUSED_RESULT SWIFT_DEPRECATED_MSG("Use getUserStatus() instead. Search for the purposeId in getUserStatus().purposes.global.enabled or getUserStatus().purposes.consent.disabled.");
/// Get the user legitimate interest status for a specific purpose.
/// \param purposeId purpose ID.
///
///
/// returns:
/// LI status of a purpose.
- (enum ConsentStatus)getUserLegitimateInterestStatusForPurposeWithPurposeId:(NSString * _Nonnull)purposeId SWIFT_WARN_UNUSED_RESULT SWIFT_DEPRECATED_MSG("Use getUserStatus() instead. Search for the purposeId in getUserStatus().purposes.global.enabled or getUserStatus().purposes.legitimateInterest.disabled.");
/// Get the user consent and legitimate interest status for a specific vendor.
/// \param vendorId vendor ID.
///
///
/// returns:
/// status that represents both consent and legitimate interest status of a vendor.
- (enum ConsentStatus)getUserStatusForVendorWithVendorId:(NSString * _Nonnull)vendorId SWIFT_WARN_UNUSED_RESULT SWIFT_DEPRECATED_MSG("Use getUserStatus() instead. Search for the vendorId in getUserStatus().vendors.global.enabled or getUserStatus().vendors.global.disabled.");
/// Get the user consent status for a specific vendor
/// \param vendorId The vendor ID to check consent for
///
///
/// returns:
/// The user consent status for the specified vendor
- (enum ConsentStatus)getUserConsentStatusForVendorWithVendorId:(NSString * _Nonnull)vendorId SWIFT_WARN_UNUSED_RESULT SWIFT_DEPRECATED_MSG("Use getUserStatus() instead. Search for the vendorId in getUserStatus().vendors.globalConsent.enabled or getUserStatus().vendors.consent.disabled.");
/// Get the user legitimate interest status for a specific vendor.
/// \param vendorId vendor ID.
///
///
/// returns:
/// LI status of a vendor.
- (enum ConsentStatus)getUserLegitimateInterestStatusForVendorWithVendorId:(NSString * _Nonnull)vendorId SWIFT_WARN_UNUSED_RESULT SWIFT_DEPRECATED_MSG("Use getUserStatus() instead. Search for the vendorId in getUserStatus().vendors.globalLegitimateInterest.enabled or getUserStatus().vendors.legitimateInterest.disabled.");
/// Get the user consent status for a specific vendor and all its purposes
/// \param vendorId The ID of the vendor
///
///
/// returns:
/// The user consent status corresponding to the specified vendor and all its required purposes.
- (enum ConsentStatus)getUserConsentStatusForVendorAndRequiredPurposesWithVendorId:(NSString * _Nonnull)vendorId SWIFT_WARN_UNUSED_RESULT SWIFT_DEPRECATED_MSG("Use getUserStatus() instead. Search for the vendorId in getUserStatus().vendors.globalConsent.enabled or getUserStatus().vendors.globalConsent.disabled.");
/// Get the user LI status for a specific vendor and all its purposes.
/// \param vendorId vendor ID.
///
///
/// returns:
/// The user LI status corresponding to the specified vendor and all its required purposes.
- (enum ConsentStatus)getUserLegitimateInterestStatusForVendorAndRequiredPurposesWithVendorId:(NSString * _Nonnull)vendorId SWIFT_WARN_UNUSED_RESULT SWIFT_DEPRECATED_MSG("Use getUserStatus() instead. Search for the vendorId in getUserStatus().vendors.globalLegitimateInterest.enabled or getUserStatus().vendors.globalLegitimateInterest.disabled.");
/// Set the user status for purposes and vendors for consent and legitimate interest.
/// \param purposesConsentStatus boolean used to determine if consent will be enabled or disabled for all purposes.
///
/// \param purposesLIStatus boolean used to determine if legitimate interest will be enabled or disabled for all purposes.
///
/// \param vendorsConsentStatus boolean used to determine if consent will be enabled or disabled for all vendors.
///
/// \param vendorsLIStatus boolean used to determine if legitimate interest will be enabled or disabled for all vendors.
///
///
/// returns:
/// <em>true</em> if consent status has been updated, <em>false</em> otherwise.
- (BOOL)setUserStatusWithPurposesConsentStatus:(BOOL)purposesConsentStatus purposesLIStatus:(BOOL)purposesLIStatus vendorsConsentStatus:(BOOL)vendorsConsentStatus vendorsLIStatus:(BOOL)vendorsLIStatus;
/// Set the user status for purposes and vendors for consent and legitimate interest.
/// \param enabledConsentPurposeIds List of purpose IDs to enable for consent.
///
/// \param disabledConsentPurposeIds List of purpose IDs to disable for consent.
///
/// \param enabledLIPurposeIds List of purpose IDs to enable for LI.
///
/// \param disabledLIPurposeIds List of purpose IDs to disable for LI.
///
/// \param enabledConsentVendorIds List of vendor IDs to enable for consent.
///
/// \param disabledConsentVendorIds List of vendor IDs to disable for consent.
///
/// \param enabledLIVendorIds List of vendor IDs to enable for LI.
///
/// \param disabledLIVendorIds List of vendor IDs to disable for LI.
///
- (BOOL)setUserStatusWithEnabledConsentPurposeIds:(NSSet<NSString *> * _Nonnull)enabledConsentPurposeIds disabledConsentPurposeIds:(NSSet<NSString *> * _Nonnull)disabledConsentPurposeIds enabledLIPurposeIds:(NSSet<NSString *> * _Nonnull)enabledLIPurposeIds disabledLIPurposeIds:(NSSet<NSString *> * _Nonnull)disabledLIPurposeIds enabledConsentVendorIds:(NSSet<NSString *> * _Nonnull)enabledConsentVendorIds disabledConsentVendorIds:(NSSet<NSString *> * _Nonnull)disabledConsentVendorIds enabledLIVendorIds:(NSSet<NSString *> * _Nonnull)enabledLIVendorIds disabledLIVendorIds:(NSSet<NSString *> * _Nonnull)disabledLIVendorIds;
/// Method that allows to enable consent and legitimate interest for all the required purposes.
///
/// returns:
/// <em>true</em> if consent status has been updated, <em>false</em> otherwise.
- (BOOL)setUserAgreeToAll;
/// Method that allows to disable consent and legitimate interest for all the required purposes and vendors.
///
/// returns:
/// <em>true</em> if consent status has been updated, <em>false</em> otherwise.
- (BOOL)setUserDisagreeToAll;
/// Provide a function that needs to be called once the SDK is ready
/// Automatically call the function if the SDK is already ready (that’s why this is not a standard event)
- (void)onReadyWithCallback:(void (^ _Nonnull)(void))callback;
/// Accepts a closure that will be called if an unexpected situation occurs.
/// \param callback closure to be called if an unexpected situation occurs.
///
- (void)onErrorWithCallback:(void (^ _Nonnull)(DDMErrorEvent * _Nonnull))callback;
/// Remove all consents for the user
- (void)reset;
/// Get the configured purpose IDs
/// @return
- (NSSet<NSString *> * _Nonnull)getRequiredPurposeIds SWIFT_WARN_UNUSED_RESULT;
/// Get the configured vendor IDs
/// @return
- (NSSet<NSString *> * _Nonnull)getRequiredVendorIds SWIFT_WARN_UNUSED_RESULT;
/// Add an event listener
/// \param listener listener to be added.
///
- (void)addEventListenerWithListener:(DDMEventListener * _Nonnull)listener;
/// Remove an event listener
/// \param listener listener to be removed.
///
- (void)removeEventListenerWithListener:(DDMEventListener * _Nonnull)listener;
/// Is the Didomi SDK ready?
- (BOOL)isReady SWIFT_WARN_UNUSED_RESULT;
/// Method used to get a set of enabled purpose IDs.
///
/// returns:
/// set that contains the IDs of enabled purposes.
- (NSSet<NSString *> * _Nonnull)getEnabledPurposeIds SWIFT_WARN_UNUSED_RESULT SWIFT_DEPRECATED_MSG("Use getUserStatus() instead. The result of this method has been replaced by getUserStatus().purposes.global.enabled.");
/// Method used to get a set of disabled purpose IDs.
///
/// returns:
/// set that contains the IDs of disabled purposes.
- (NSSet<NSString *> * _Nonnull)getDisabledPurposeIds SWIFT_WARN_UNUSED_RESULT SWIFT_DEPRECATED_MSG("Use getUserStatus() instead. The result of this method has been replaced by getUserStatus().purposes.consent.disabled.");
/// Method used to get a set of enabled vendor IDs.
///
/// returns:
/// set that contains the IDs of enabled vendors.
- (NSSet<NSString *> * _Nonnull)getEnabledVendorIds SWIFT_WARN_UNUSED_RESULT SWIFT_DEPRECATED_MSG("Use getUserStatus() instead. The result of this method has been replaced by getUserStatus().vendors.consent.enabled.");
/// Method used to get a set of disabled vendor IDs.
///
/// returns:
/// set that contains the IDs of disabled vendors.
- (NSSet<NSString *> * _Nonnull)getDisabledVendorIds SWIFT_WARN_UNUSED_RESULT SWIFT_DEPRECATED_MSG("Use getUserStatus() instead. The result of this method has been replaced by getUserStatus().vendors.consent.disabled.");
/// Get JavaScript to embed into a WebView to pass the consent status from the app
/// to the Didomi Web SDK embedded into the WebView
/// Inject the returned JavaScript into a WebView
/// \param extra Extra JavaScript to inject in the returned code
///
///
/// returns:
/// JavaScript code to inject in a WebView
- (NSString * _Nonnull)getJavaScriptForWebViewWithExtra:(NSString * _Nonnull)extra SWIFT_WARN_UNUSED_RESULT;
/// Get a query-string to add to the URL of a WebView or Chrome Custom Tab to pass the consent status from the app to the Didomi Web SDK embedded on the target URL.
/// The returned parameter will have the format <code>didomiConfig.user.externalConsent.value=...</code> It includes the user consent information URL-encoded and JSON-encoded.
/// Append the returned query-string parameter to the URL of your WebView or SFSafariViewController.
/// See https://developers.didomi.io/cmp/mobile-sdk/share-consent-with-webviews for more information.
///
/// returns:
/// Query string parameter to append to URL
- (NSString * _Nonnull)getQueryStringForWebView SWIFT_WARN_UNUSED_RESULT;
/// Method used to update the selected language of the Didomi SDK and any property that depends on it.
/// In most cases this method doesn’t need to be called. It would only be required for those apps that allow language change on-the-fly, i.e.: from within the app rather than from the device settings.
/// In order to update the language of the views displayed by the Didomi SDK, this method needs to be called before these views are displayed.
/// \param languageCode string containing the language code e.g.: “es”, “fr”, etc.
///
- (void)updateSelectedLanguageWithLanguageCode:(NSString * _Nonnull)languageCode;
@end

typedef SWIFT_ENUM(NSInteger, Views, open) {
  ViewsPurposes = 0,
  ViewsSensitivePersonalInformation = 1,
  ViewsVendors = 2,
};

@class UIViewController;

/// Protocol used to provide the view controllers for the preferences/purposes and notice view.
/// To provide customs views, this protocol will have to be implemented.
/// This protocol is implemented by the Didomi singleton to provide the default view controllers.
SWIFT_PROTOCOL("_TtP6Didomi20ViewProviderDelegate_")
@protocol ViewProviderDelegate
/// Method used to provide a view controller that will be used to display the notice.
/// \param position string that represents the position of the notice (e.g.: bottom, popup, etc.).
///
/// \param skipped Whether notice display is skipped and Preferences are displayed directly
///
///
/// returns:
/// the view controller associated to the notice.
- (UIViewController * _Nonnull)getNoticeViewControllerWithPosition:(NSString * _Nonnull)position noticeSkipped:(BOOL)noticeSkipped SWIFT_WARN_UNUSED_RESULT;
/// Method used to provide a view controller that will be used to display the preferences/purposes view.
///
/// returns:
/// the view controller associated to the preferences/purposes view.
- (UIViewController * _Nonnull)getPreferencesViewController SWIFT_WARN_UNUSED_RESULT;
@end


@interface Didomi (SWIFT_EXTENSION(Didomi)) <ViewProviderDelegate>
- (UIViewController * _Nonnull)getNoticeViewControllerWithPosition:(NSString * _Nonnull)position noticeSkipped:(BOOL)noticeSkipped SWIFT_WARN_UNUSED_RESULT;
- (UIViewController * _Nonnull)getPreferencesViewController SWIFT_WARN_UNUSED_RESULT;
@end

@class UserAuthParams;
@class DDMUserStatus;

@interface Didomi (SWIFT_EXTENSION(Didomi))
/// Provide the objects required to display UI elements
- (void)setupUIWithContainerController:(UIViewController * _Nonnull)containerController;
/// Force show the consent notice without checking if consent is required
/// Important: Do not keep a local reference to the View Controller itself as that could create a memory leak
- (void)forceShowNotice;
/// Show the consent notice (if required, not disabled in the config and not already displayed)
- (void)showNotice;
/// Hide the notice if it is currently displayed
- (void)hideNotice;
/// Check if the consent notice is currently displayed
/// @return
- (BOOL)isNoticeVisible SWIFT_WARN_UNUSED_RESULT;
/// Check if the consent should be collected depending on if we have any consents or if we have some consents but the number of days before displaying the notice again has not expired yet
///
/// returns:
/// A boolean depending if the consent should be collected or not
- (BOOL)shouldConsentBeCollected SWIFT_WARN_UNUSED_RESULT;
/// Show the preferences screen when/if the SDK is ready. By default the purposes list will be displayed.
/// \param controller view controller from where preferences will be presented.
///
/// \param view a value from <code>Didomi.Views</code>. It can be <code>.purposes</code> or <code>.sensitivePersonalInformation</code> or <code>.vendors</code> (<code>ViewsPurposes</code> or <code>ViewsSensitivePersonalInformation</code> or <code>ViewsVendors</code> in Objective-C)
///
- (void)showPreferencesWithController:(UIViewController * _Nullable)controller view:(enum Views)view;
/// Hide the preferences popup for purposes
- (void)hidePreferences;
/// Method used to check if the Preferences view is visible.
///
/// returns:
/// <em>true</em> if Preferences view is visible, <em>false</em> otherwise.
- (BOOL)isPreferencesVisible SWIFT_WARN_UNUSED_RESULT;
/// Method used to get a translated text based on the key being passed.
/// The language and the source of this translated text will depend on the availability of the translation for the specific key.
/// The language being used will be either the selected language of the SDK (based on device Locale and other parameters) or the language specified by app developers as the default language being used by the SDK. The source can be either the <code>didomi_config.json</code> file which can be either local or remote, or the <code>didomi_master_config.json</code> file which is bundled within the SDK.
/// These are the attempts performed by the SDK to try to find a translation for the specific key:
/// <ul>
///   <li>
///     Get translated value in user locale (selected language) from <code>didomi_config.json</code> (either local or remote).
///   </li>
///   <li>
///     Get translated value in default locale (from the config) from <code>didomi_config.json</code> (either local or remote).
///   </li>
///   <li>
///     Get translated value in user locale (selected language) from <code>didomi_master_config.json</code> (bundled within the Didomi SDK).
///   </li>
///   <li>
///     Get translated value in default locale (from the config) from <code>didomi_master_config.json</code> (bundled within the Didomi SDK).
///   </li>
/// </ul>
/// If no translation can be found after these 4 attempts, the key will be returned.
/// App developers can provide these translated texts through the <code>didomi_config.json</code> file (locally or remotely) in 3 different ways:
/// <ul>
///   <li>
///     Custom texts for the consent notice: https://developers.didomi.io/cmp/mobile-sdk/consent-notice/customize-the-notice#texts
///   </li>
///   <li>
///     Custom texts for the preferences: https://developers.didomi.io/cmp/mobile-sdk/consent-notice/customize-the-preferences-popup#text
///   </li>
///   <li>
///     Custom texts for custom notices: https://developers.didomi.io/cmp/mobile-sdk/consent-notice/customize-the-theme#translatable-texts-for-custom-notices
///   </li>
/// </ul>
/// \param key used to find its corresponding value in one of the different sources.
///
///
/// returns:
/// a translated string if a translation was found, the same key that was passed otherwise.
- (NSString * _Nonnull)getTranslatedTextWithKey:(NSString * _Nonnull)key SWIFT_WARN_UNUSED_RESULT;
/// Method used to get a dictionary/map in the form of { “en”: “Key in English”, “fr”: “Key in French.” }
/// for a given key.
/// \param key used to find its corresponding value in the dictionary/map.
///
///
/// returns:
/// dictionary containing the different translations for a given key.
- (NSDictionary<NSString *, NSString *> * _Nullable)getTextWithKey:(NSString * _Nonnull)key SWIFT_WARN_UNUSED_RESULT;
/// Set the minimum level of messages to log
/// Messages with a level below <code>minLevel</code> will not be logged.
/// Levels are standard levels from <code>OSLogType</code> (https://developer.apple.com/documentation/os/logging/choosing_the_log_level_for_a_message):
/// <ul>
///   <li>
///     OSLogType.info (1)
///   </li>
///   <li>
///     OSLogType.debug (2)
///   </li>
///   <li>
///     OSLogType.error (16)
///   </li>
///   <li>
///     OSLogType.fault (17)
///   </li>
/// </ul>
/// We recommend setting <code>OSLogType.error</code> (16) in production
/// \param minLevel Minimum level of messages to log
///
- (void)setLogLevelWithMinLevel:(uint8_t)minLevel;
/// Set organization user information
/// \param id Organization user ID
///
- (void)setUserWithId:(NSString * _Nonnull)id;
/// Set organization user information and display consent notice if it is needed after synchronization
/// \param id Organization user ID
///
/// \param containerController View controller from which we can setup Didomi UI
///
- (void)setUserWithId:(NSString * _Nonnull)id containerController:(UIViewController * _Nonnull)containerController;
/// Set organization user information with authentication
/// \param userAuthParams Organization user authentication params
///
- (void)setUserWithUserAuthParams:(UserAuthParams * _Nonnull)userAuthParams;
/// Set organization user information with authentication, and display consent notice if it is needed after synchronization
/// \param userAuthParams Organization user authentication params
///
/// \param containerController View controller from which we can setup Didomi UI
///
- (void)setUserWithUserAuthParams:(UserAuthParams * _Nonnull)userAuthParams containerController:(UIViewController * _Nonnull)containerController;
/// Set user information with authentication
/// \param id Organization user ID
///
/// \param algorithm Algorithm used for computing the digest
///
/// \param secretId ID of the secret used for computing the digest
///
/// \param salt Salt used for computing the digest (optional)
///
/// \param digest Digest of the organization user ID and secret
///
- (void)setUserWithId:(NSString * _Nonnull)id algorithm:(NSString * _Nonnull)algorithm secretId:(NSString * _Nonnull)secretId salt:(NSString * _Nullable)salt digest:(NSString * _Nonnull)digest SWIFT_DEPRECATED_MSG("Use setUser(UserAuthParams) instead.");
/// Remove organization user information (should be called when the SDK is initialized).
- (void)clearUser;
- (DDMUserStatus * _Nonnull)getUserStatus SWIFT_WARN_UNUSED_RESULT;
@end

enum DDMErrorEventType : NSInteger;

/// Type used to represent unexpected situations during SDK initialization.
SWIFT_CLASS_NAMED("DidomiErrorEvent")
@interface DDMErrorEvent : NSObject
@property (nonatomic, readonly, copy) NSString * _Nonnull descriptionText;
@property (nonatomic, readonly) enum DDMErrorEventType type;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// Enum used to represent a type for the DidomiErrorEvent class.
typedef SWIFT_ENUM_NAMED(NSInteger, DDMErrorEventType, "DidomiErrorEventType", open) {
  DDMErrorEventTypeNilProperty = 0,
  DDMErrorEventTypeNotReady = 1,
  DDMErrorEventTypeFailedAlready = 2,
  DDMErrorEventTypeConfigFileError = 3,
  DDMErrorEventTypeInvalidApiKey = 4,
};


/// Initialization parameters for Didomi SDK
SWIFT_CLASS("_TtC6Didomi26DidomiInitializeParameters")
@interface DidomiInitializeParameters : NSObject
- (nonnull instancetype)initWithApiKey:(NSString * _Nonnull)apiKey localConfigurationPath:(NSString * _Nullable)localConfigurationPath remoteConfigurationURL:(NSString * _Nullable)remoteConfigurationURL providerID:(NSString * _Nullable)providerID disableDidomiRemoteConfig:(BOOL)disableDidomiRemoteConfig languageCode:(NSString * _Nullable)languageCode noticeID:(NSString * _Nullable)noticeID OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


enum DDMEventType : NSInteger;

/// Class used as a listener for internal events occurred in the SDK.
SWIFT_CLASS_NAMED("EventListener")
@interface DDMEventListener : NSObject
/// Closures used to execute code when the different events are triggered.
/// Internal
@property (nonatomic, copy) void (^ _Nonnull onConsentChanged)(enum DDMEventType);
@property (nonatomic, copy) void (^ _Nonnull onReady)(enum DDMEventType);
@property (nonatomic, copy) void (^ _Nonnull onError)(DDMErrorEvent * _Nonnull);
/// Notice
@property (nonatomic, copy) void (^ _Nonnull onHideNotice)(enum DDMEventType);
@property (nonatomic, copy) void (^ _Nonnull onShowNotice)(enum DDMEventType);
@property (nonatomic, copy) void (^ _Nonnull onNoticeClickAgree)(enum DDMEventType);
@property (nonatomic, copy) void (^ _Nonnull onNoticeClickDisagree)(enum DDMEventType);
@property (nonatomic, copy) void (^ _Nonnull onNoticeClickMoreInfo)(enum DDMEventType);
@property (nonatomic, copy) void (^ _Nonnull onNoticeClickViewVendors)(enum DDMEventType);
@property (nonatomic, copy) void (^ _Nonnull onNoticeClickViewSPIPurposes)(enum DDMEventType);
@property (nonatomic, copy) void (^ _Nonnull onNoticeClickPrivacyPolicy)(enum DDMEventType);
/// Preferences
@property (nonatomic, copy) void (^ _Nonnull onHidePreferences)(enum DDMEventType);
@property (nonatomic, copy) void (^ _Nonnull onShowPreferences)(enum DDMEventType);
/// Preferences - Views
@property (nonatomic, copy) void (^ _Nonnull onPreferencesClickViewPurposes)(enum DDMEventType);
@property (nonatomic, copy) void (^ _Nonnull onPreferencesClickViewVendors)(enum DDMEventType);
@property (nonatomic, copy) void (^ _Nonnull onPreferencesClickViewSPIPurposes)(enum DDMEventType);
/// Preferences - Purpose
@property (nonatomic, copy) void (^ _Nonnull onPreferencesClickAgreeToAll)(enum DDMEventType);
@property (nonatomic, copy) void (^ _Nonnull onPreferencesClickDisagreeToAll)(enum DDMEventType);
@property (nonatomic, copy) void (^ _Nonnull onPreferencesClickAgreeToAllPurposes)(enum DDMEventType);
@property (nonatomic, copy) void (^ _Nonnull onPreferencesClickDisagreeToAllPurposes)(enum DDMEventType);
@property (nonatomic, copy) void (^ _Nonnull onPreferencesClickResetAllPurposes)(enum DDMEventType);
@property (nonatomic, copy) void (^ _Nonnull onPreferencesClickPurposeAgree)(enum DDMEventType, NSString * _Nullable);
@property (nonatomic, copy) void (^ _Nonnull onPreferencesClickPurposeDisagree)(enum DDMEventType, NSString * _Nullable);
@property (nonatomic, copy) void (^ _Nonnull onPreferencesClickCategoryAgree)(enum DDMEventType, NSString * _Nullable);
@property (nonatomic, copy) void (^ _Nonnull onPreferencesClickCategoryDisagree)(enum DDMEventType, NSString * _Nullable);
@property (nonatomic, copy) void (^ _Nonnull onPreferencesClickSaveChoices)(enum DDMEventType);
/// Preferences - Vendor
@property (nonatomic, copy) void (^ _Nonnull onPreferencesClickAgreeToAllVendors)(enum DDMEventType);
@property (nonatomic, copy) void (^ _Nonnull onPreferencesClickDisagreeToAllVendors)(enum DDMEventType);
@property (nonatomic, copy) void (^ _Nonnull onPreferencesClickVendorAgree)(enum DDMEventType, NSString * _Nullable);
@property (nonatomic, copy) void (^ _Nonnull onPreferencesClickVendorDisagree)(enum DDMEventType, NSString * _Nullable);
@property (nonatomic, copy) void (^ _Nonnull onPreferencesClickVendorSaveChoices)(enum DDMEventType);
/// Preferences - Sensitive Personal Information
@property (nonatomic, copy) void (^ _Nonnull onPreferencesClickSPIPurposeAgree)(enum DDMEventType, NSString * _Nullable);
@property (nonatomic, copy) void (^ _Nonnull onPreferencesClickSPIPurposeDisagree)(enum DDMEventType, NSString * _Nullable);
@property (nonatomic, copy) void (^ _Nonnull onPreferencesClickSPICategoryAgree)(enum DDMEventType, NSString * _Nullable);
@property (nonatomic, copy) void (^ _Nonnull onPreferencesClickSPICategoryDisagree)(enum DDMEventType, NSString * _Nullable);
@property (nonatomic, copy) void (^ _Nonnull onPreferencesClickSPIPurposeSaveChoices)(enum DDMEventType);
/// Sync
@property (nonatomic, copy) void (^ _Nonnull onSyncDone)(enum DDMEventType, NSString * _Nullable);
@property (nonatomic, copy) void (^ _Nonnull onSyncError)(enum DDMEventType, NSString * _Nullable);
/// Language
@property (nonatomic, copy) void (^ _Nonnull onLanguageUpdated)(enum DDMEventType, NSString * _Nullable);
@property (nonatomic, copy) void (^ _Nonnull onLanguageUpdateFailed)(enum DDMEventType, NSString * _Nullable);
- (nonnull instancetype)init OBJC_DESIGNATED_INITIALIZER;
@end

/// Enum used to define the different type of internal events that can be triggered from the SDK.
/// Please keep the current order because of Unity bridge.
typedef SWIFT_ENUM_NAMED(NSInteger, DDMEventType, "EventType", open) {
  DDMEventTypeConsentChanged = 0,
  DDMEventTypeHideNotice = 1,
  DDMEventTypeReady = 2,
  DDMEventTypeShowNotice = 3,
  DDMEventTypeShowPreferences = 4,
  DDMEventTypeHidePreferences = 5,
  DDMEventTypeNoticeClickAgree = 6,
  DDMEventTypeNoticeClickDisagree = 7,
  DDMEventTypeNoticeClickMoreInfo = 8,
  DDMEventTypeNoticeClickViewVendors = 9,
  DDMEventTypeNoticeClickPrivacyPolicy = 10,
  DDMEventTypePreferencesClickAgreeToAll = 11,
  DDMEventTypePreferencesClickDisagreeToAll = 12,
  DDMEventTypePreferencesClickAgreeToAllPurposes = 13,
  DDMEventTypePreferencesClickDisagreeToAllPurposes = 14,
  DDMEventTypePreferencesClickResetAllPurposes = 15,
  DDMEventTypePreferencesClickAgreeToAllVendors = 16,
  DDMEventTypePreferencesClickDisagreeToAllVendors = 17,
  DDMEventTypePreferencesClickPurposeAgree = 18,
  DDMEventTypePreferencesClickPurposeDisagree = 19,
  DDMEventTypePreferencesClickCategoryAgree = 20,
  DDMEventTypePreferencesClickCategoryDisagree = 21,
  DDMEventTypePreferencesClickViewVendors = 22,
  DDMEventTypePreferencesClickViewPurposes = 23,
  DDMEventTypePreferencesClickSaveChoices = 24,
  DDMEventTypePreferencesClickVendorAgree = 25,
  DDMEventTypePreferencesClickVendorDisagree = 26,
  DDMEventTypePreferencesClickVendorSaveChoices = 27,
/// Sync
  DDMEventTypeSyncDone = 28,
  DDMEventTypeSyncError = 29,
/// Language
  DDMEventTypeLanguageUpdated = 30,
  DDMEventTypeLanguageUpdateFailed = 31,
/// Preferences - Sensitive Personal Information
  DDMEventTypeNoticeClickViewSPIPurposes = 32,
  DDMEventTypePreferencesClickViewSPIPurposes = 33,
  DDMEventTypePreferencesClickSPIPurposeAgree = 34,
  DDMEventTypePreferencesClickSPIPurposeDisagree = 35,
  DDMEventTypePreferencesClickSPICategoryAgree = 36,
  DDMEventTypePreferencesClickSPICategoryDisagree = 37,
  DDMEventTypePreferencesClickSPIPurposeSaveChoices = 38,
};






@class NSCoder;
@protocol UIFocusEnvironment;
@class NSBundle;

SWIFT_CLASS("_TtC6Didomi20NoticeViewController")
@interface NoticeViewController : UIViewController
- (nullable instancetype)initWithCoder:(NSCoder * _Nonnull)aDecoder OBJC_DESIGNATED_INITIALIZER;
- (void)viewDidLoad;
@property (nonatomic, readonly, copy) NSArray<id <UIFocusEnvironment>> * _Nonnull preferredFocusEnvironments;
- (nonnull instancetype)initWithNibName:(NSString * _Nullable)nibNameOrNil bundle:(NSBundle * _Nullable)nibBundleOrNil SWIFT_UNAVAILABLE;
@end




/// Regulation for which Didomi SDK is currently configured. Only one regulation is active at each run.
typedef SWIFT_ENUM(NSInteger, Regulation, open) {
  RegulationGdpr = 0,
  RegulationCcpa = 1,
  RegulationCpa = 2,
  RegulationCpra = 3,
  RegulationCtdpa = 4,
  RegulationUcpa = 5,
  RegulationVcdpa = 6,
  RegulationNone = 7,
};


















/// Protocol for User Authentication
/// declare the user id
SWIFT_PROTOCOL("_TtP6Didomi8UserAuth_")
@protocol UserAuth
/// Organization ID to associate with the user
@property (nonatomic, readonly, copy) NSString * _Nonnull id;
@end


/// Protocol for User Authentication Parameters
/// declare the common properties of encryption / hash parameters
SWIFT_CLASS("_TtC6Didomi14UserAuthParams")
@interface UserAuthParams : NSObject <UserAuth>
/// Organization ID to associate with the user
@property (nonatomic, copy) NSString * _Nonnull id;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


/// User Authentication Parameters with encryption
SWIFT_CLASS("_TtC6Didomi28UserAuthWithEncryptionParams")
@interface UserAuthWithEncryptionParams : UserAuthParams
- (nonnull instancetype)initWithId:(NSString * _Nonnull)id algorithm:(NSString * _Nonnull)algorithm secretID:(NSString * _Nonnull)secretID initializationVector:(NSString * _Nonnull)initializationVector;
/// Initializer for Objective-C
- (nonnull instancetype)initWithId:(NSString * _Nonnull)id algorithm:(NSString * _Nonnull)algorithm secretID:(NSString * _Nonnull)secretID initializationVector:(NSString * _Nonnull)initializationVector legacyExpiration:(NSTimeInterval)legacyExpiration;
/// Initialization Vector used for computing the user ID
@property (nonatomic, copy) NSString * _Nonnull initializationVector;
@end


/// User Authentication Parameters with hash
SWIFT_CLASS("_TtC6Didomi22UserAuthWithHashParams")
@interface UserAuthWithHashParams : UserAuthParams
- (nonnull instancetype)initWithId:(NSString * _Nonnull)id algorithm:(NSString * _Nonnull)algorithm secretID:(NSString * _Nonnull)secretID digest:(NSString * _Nonnull)digest salt:(NSString * _Nullable)salt;
/// Initializer for Objective-C
- (nonnull instancetype)initWithId:(NSString * _Nonnull)id algorithm:(NSString * _Nonnull)algorithm secretID:(NSString * _Nonnull)secretID digest:(NSString * _Nonnull)digest salt:(NSString * _Nullable)salt legacyExpiration:(NSTimeInterval)legacyExpiration;
/// Salt used for computing the user ID (optional)
@property (nonatomic, copy) NSString * _Nullable salt;
/// Digest used for representing the user ID
@property (nonatomic, copy) NSString * _Nonnull digest;
@end

@class DDMUserStatusPurposes;
@class DDMUserStatusVendors;

SWIFT_CLASS_NAMED("UserStatus")
@interface DDMUserStatus : NSObject
@property (nonatomic, readonly, strong) DDMUserStatusPurposes * _Nonnull purposes;
@property (nonatomic, readonly, strong) DDMUserStatusVendors * _Nonnull vendors;
@property (nonatomic, readonly, copy) NSString * _Nonnull userID;
@property (nonatomic, readonly, copy) NSString * _Nonnull created;
@property (nonatomic, readonly, copy) NSString * _Nonnull updated;
@property (nonatomic, readonly, copy) NSString * _Nonnull consentString;
@property (nonatomic, readonly, copy) NSString * _Nonnull additionalConsent;
@property (nonatomic, readonly) enum Regulation regulation;
- (BOOL)isEqual:(id _Nullable)object SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


@interface DDMUserStatus (SWIFT_EXTENSION(Didomi))
@end

@class DDMUserStatusIDs;

SWIFT_CLASS_NAMED("Purposes")
@interface DDMUserStatusPurposes : NSObject
@property (nonatomic, readonly, strong) DDMUserStatusIDs * _Nonnull consent;
@property (nonatomic, readonly, strong) DDMUserStatusIDs * _Nonnull legitimateInterest;
@property (nonatomic, readonly, strong) DDMUserStatusIDs * _Nonnull global;
@property (nonatomic, readonly, copy) NSSet<NSString *> * _Nonnull essential;
- (BOOL)isEqual:(id _Nullable)object SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


@interface DDMUserStatus (SWIFT_EXTENSION(Didomi))
@end


SWIFT_CLASS_NAMED("Vendors")
@interface DDMUserStatusVendors : NSObject
@property (nonatomic, readonly, strong) DDMUserStatusIDs * _Nonnull consent;
@property (nonatomic, readonly, strong) DDMUserStatusIDs * _Nonnull legitimateInterest;
@property (nonatomic, readonly, strong) DDMUserStatusIDs * _Nonnull global;
@property (nonatomic, readonly, strong) DDMUserStatusIDs * _Nonnull globalConsent;
@property (nonatomic, readonly, strong) DDMUserStatusIDs * _Nonnull globalLegitimateInterest;
- (BOOL)isEqual:(id _Nullable)object SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end


@interface DDMUserStatus (SWIFT_EXTENSION(Didomi))
@end


SWIFT_CLASS_NAMED("IDs")
@interface DDMUserStatusIDs : NSObject
@property (nonatomic, readonly, copy) NSSet<NSString *> * _Nonnull enabled;
@property (nonatomic, readonly, copy) NSSet<NSString *> * _Nonnull disabled;
- (BOOL)isEqual:(id _Nullable)object SWIFT_WARN_UNUSED_RESULT;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end



#if __has_attribute(external_source_symbol)
# pragma clang attribute pop
#endif
#pragma clang diagnostic pop
#endif

#endif
